* Title: 	figure5.do
* Version: 	23 May 2018
* Purpose: 	Produce graph of joblessness categories


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure5, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use year statefip PrimeMaleD UnempB JoblessStatusI wtsupp ///
	using dta/asec_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only 1994-2016
keep if year >= 1994

* Keep only continental 48 states (excluding District of Columbia)
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)


*******************************************************************************
* (2) Construct rates for joblessness categories
*******************************************************************************

gen Employed	= (JoblessStatusI == 0)
gen Unemployed	= (JoblessStatusI == 1)
gen NILF_WantJob = (JoblessStatusI == 2)
gen NILF_DontWantJob = (JoblessStatusI == 3)
 
egen test = rowtotal(Employed Unemployed NILF_WantJob NILF_DontWantJob)
assert test == 1
drop test

collapse (sum) Total = PrimeMaleD Employed Unemployed NILF_WantJob NILF_DontWantJob ///
		 [pw=wtsupp], by(year)

tsset year
foreach var of varlist Unemployed NILF_WantJob NILF_DontWantJob {
	gen `var'_Rate = 100 * (L.`var' + `var' + F.`var') / (L.Total + Total + F.Total)
}

keep year *_Rate 
keep if (year >= 1995 & year <= 2015)

* Save dataset
save output/figures/dta/figure5.dta, replace


*******************************************************************************
* (3) Produce graph
*******************************************************************************

line 	Unemployed_Rate NILF_WantJob_Rate NILF_DontWantJob_Rate year, ///
		legend(label(1 "Unemployed") label(2 "NILF, want job") label(3 "NILF, don't want job") size(small)) ///
		graphregion(color(white)) bgcolor(white)  ///
		xtitle("Year") ytitle("Share of prime age men, percent")
		
graph save output/figures/gph/figure5, replace
graph export output/figures/eps/figure5.eps, as(eps) replace
export excel using output/figures/xlsx/figure5.xlsx, first(variables) replace


*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
